// main.c

//4-5-98
//Version 0.8
//Some modifications made by Chris Dohnal (cwdohnal@ucdavis.edu)

// Contains the .dll entry point and overridden functions
// uses imports.c for loading symbols, dib.c for getting framebuffer access.

// Copr. 1998 - Justin Frankel/Nullsoft, Inc. (http://www.nullsoft.com)

// Version 0.5 - 1/4/1998

#include <windows.h>

#define FX_GLIDE_NO_FUNC_PROTO
#include <glide.h>
#include <glideutl.h>

#include "pointers.h"
#include "cwg.h"
#include "imports.h"
#include "inifile.h"

#define ENTRY __declspec(dllexport)
#define CALL __stdcall

HANDLE ghDllInst;
BOOL gbEnable = 1;
DWORD gdwScreenWidth, gdwScreenHeight;
GrOriginLocation_t gOriginLocation;
DWORD gdwGlideScreenWidth, gdwGlideScreenHeight;

//DLL entry point
//Called on load/unload of the .dll. Loads or frees the real glide2x.dll.
BOOL WINAPI DllMain(HINSTANCE hDllInst, DWORD fdwReason, LPVOID lpvReserved) {
	static HINSTANCE hGlide = NULL;
	
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:
		//Save the handle of the dll
		ghDllInst = hDllInst;

		//Load ini file settings that need to be read before window creation
		DllInitLoadINIFile();

		//Load the read glide2x.dll
		hGlide = LoadSymbols(hDllInst);
		if (hGlide == NULL) {
			return FALSE;
		}
		break;
	
	case DLL_PROCESS_DETACH:
		//Free the Glide library
		if (hGlide != NULL) {
			FreeLibrary(hGlide);
			hGlide = NULL;
		}

		break;
	
	default:
		break;
	}
	return TRUE;
}


// Our new, overridden functions go here. 

// override grSstWinOpen, for opening the 3dfx hardware.
ENTRY FxBool CALL grSstWinOpen(FxU32 hFxWnd, GrScreenResolution_t grResolution,
	GrScreenRefresh_t grRefresh, GrColorFormat_t grColorFormat,
	GrOriginLocation_t grOriginLocation, int nColBuffers, int nAuxBuffers) {
	
	HWND hWnd;


	//See if the 320x240 fix for the new MiniGL should be applied
	if (gb320x240Fix == TRUE) {
		//If a resolution of 320x240 is detected, change it to 512x384
		if (grResolution == GR_RESOLUTION_320x240) {
			grResolution = GR_RESOLUTION_512x384;
		}
	}
	
	if (_grSstWinOpen(hFxWnd, grResolution, grRefresh, grColorFormat,
		grOriginLocation, nColBuffers, nAuxBuffers) == FXFALSE) {
		
		return FXFALSE;
	}

	//Save the origin location being used
	gOriginLocation = grOriginLocation;

	//Get the width and height of the screen
	gdwScreenWidth = _grSstScreenWidth();
	gdwScreenHeight = _grSstScreenHeight();
	
	//Save the width and height of the screen
	gdwGlideScreenWidth = gdwScreenWidth;
	gdwGlideScreenHeight = gdwScreenHeight;
		
	//Get hFxWnd as a HWND
	hWnd = (HWND)hFxWnd;

	//Decide if we are running full screen or windowed
	gbEnable = FALSE;
	if ((hWnd != NULL) && IsWindow(hWnd)) {
		RECT rect;		

		GetWindowRect(hWnd, &rect);		
		if (!((rect.left == 0) && (rect.top == 0) && ((DWORD)rect.right == gdwScreenWidth) && ((DWORD)rect.bottom == gdwScreenHeight))) {
			gbEnable = TRUE;
		}
	}

	//If enabled, initialize
	if (gbEnable == TRUE) {
		RECT rect;
		BOOL bRet;

		GetClientRect(hWnd, &rect);

		gdwScreenWidth = rect.right;
		gdwScreenHeight = rect.bottom;
		
		_grSstControl(GR_CONTROL_DEACTIVATE);		
		_grRenderBuffer(GR_BUFFER_BACKBUFFER);

		//Call CWG initialization function
		bRet = CWGInitialize(hWnd, gdwScreenWidth, gdwScreenHeight);

		//Close the window if initialization failed
		if (bRet == FALSE) {
			//Call CWG shutdown function
			CWGShutdown();

			//Close the window on the 3Dfx card
			_grSstWinClose();

			return FXFALSE;
		}
	}

	return FXTRUE;
}

// override grBufferSwap to copy the hardware's data into our DIBSection
ENTRY void CALL grBufferSwap(int swapInterval) {
	if (gbEnable == TRUE) {
		CWGCopy3DfxFrameBuffer();
	}
	else {
		_grBufferSwap(swapInterval);
	}
	return;
}

// override grSstWinClose to delete our DIB
ENTRY void CALL grSstWinClose(void) {
	
	_grSstWinClose();
	
	if (gbEnable == TRUE) {
		//Call CWG shutdown function
		CWGShutdown();
	}
	return;
}

// override grSstControl to keep the calling app from reenabling the hardware's video output
ENTRY FxBool CALL grSstControl(FxU32 code) {
	if (gbEnable == TRUE) {
		return CWGControl(code);
	}
	return _grSstControl(code);
}
